<?php

$filename = 'forecast_' . date('Y-m-d') . '.json';

// Check if the file exists
if (!file_exists($filename)) {
    // If the file doesn't exist, send a new request
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://api.forecast.solar/estimate/32.5449/52.4837/25/70/50',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
    ));

    $response = curl_exec($curl);

    curl_close($curl);

    // Save the response in the JSON file
    file_put_contents($filename, $response);

    // Set the Content-Type header to application/json
    header('Content-Type: application/json');

    // Echo the response
    echo $response;
} else {
    // If the file exists, read and echo its content
    $content = file_get_contents($filename);

    // Set the Content-Type header to application/json
    header('Content-Type: application/json');

    // Echo the content of the existing JSON file
    echo $content;
}
?>
