<?php

require 'vendor/autoload.php'; // Include PhpSpreadsheet autoload file

use PhpOffice\PhpSpreadsheet\IOFactory;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if a file was uploaded
    if (isset($_FILES['excelFile']) && $_FILES['excelFile']['error'] == 0) {
        $uploadedFile = $_FILES['excelFile']['tmp_name'];

        // Load the Excel file
        $spreadsheet = IOFactory::load($uploadedFile);

        // Get the active sheet
        $sheet = $spreadsheet->getActiveSheet();

        // Get all data from column A to D
        $dataArray = $sheet->toArray(null, true, true, true);

        // Initialize an array to store the results
        $results = [];

        // Loop through each hour within the specified range (7:00 to 18:00)
        for ($hour = 7; $hour <= 18; $hour++) {
            // Find the rows that match the current hour
            $matchingRows = array_filter($dataArray, function ($row) use ($hour) {
                $rowHour = date('H', strtotime($row['A']));
                return $rowHour == $hour;
            });

            // Calculate the difference between the first and last values of column D
            $firstValue = reset($matchingRows)['D'];
            $lastValue = end($matchingRows)['D'];
            $valueDifference = $lastValue - $firstValue;

            // Store the result in the array
            $results[$hour] = $valueDifference;
        }

        // Convert the results array to JSON
        $jsonResponse = json_encode($results, JSON_PRETTY_PRINT);

        // Output the JSON response
        header('Content-Type: application/json');
        echo $jsonResponse;

        // Optionally, you can save the uploaded file if needed
        // move_uploaded_file($uploadedFile, 'uploads/' . $_FILES['excelFile']['name']);
    } else {
        echo 'Error uploading file.';
    }
} else {
    header('Location: index.html'); // Redirect to the form page if accessed directly
}

?>
