'use strict';
(function() {
    var db = {
        loadData: function(filter) {
            return $.grep(this.clients, function(client) {
                return (!filter.Name || client.Name.indexOf(filter.Name) > -1)
                    && (!filter.Age || client.Age === filter.Age)
                    && (!filter.Address || client.Address.indexOf(filter.Address) > -1)
                    && (!filter.Country || client.Country === filter.Country)
                    && (filter.Married === undefined || client.Married === filter.Married);
            });
        },
        insertItem: function(insertingClient) {
            this.clients.push(insertingClient);
        },
        updateItem: function(updatingClient) { },

        deleteItem: function(deletingClient) {
            var clientIndex = $.inArray(deletingClient, this.clients);
            this.clients.splice(clientIndex, 1);
        }
    };
    window.db = db;
    db.countries = [
        { Name: "هند", Id: 0 },
        { Name: "آمریکا", Id: 1 },
        { Name: "کانادا", Id: 2 },
        { Name: "ایران", Id: 3 },
        { Name: "فرانسه", Id: 4 },
        { Name: "برزیل", Id: 5 },
        { Name: "چین", Id: 6 },
        { Name: "روسیه", Id: 7 }
    ];
    db.clients = [
        {
            "Name": "جان دئو",
            "Age": 61,
            "Country": 6,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 73,
            "Country": 7,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 29,
            "Country": 7,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 78,
            "Country": 1,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 43,
            "Country": 5,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 51,
            "Country": 1,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 59,
            "Country": 1,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 58,
            "Country": 1,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 62,
            "Country": 2,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 39,
            "Country": 5,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 28,
            "Country": 5,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 49,
            "Country": 7,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 20,
            "Country": 7,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 63,
            "Country": 1,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 33,
            "Country": 5,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 59,
            "Country": 1,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 24,
            "Country": 1,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 73,
            "Country": 7,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 55,
            "Country": 5,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 48,
            "Country": 4,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 59,
            "Country": 2,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 79,
            "Country": 3,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 20,
            "Country": 3,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 31,
            "Country": 5,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 36,
            "Country": 2,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 21,
            "Country": 1,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 31,
            "Country": 2,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 70,
            "Country": 7,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 39,
            "Country": 2,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 38,
            "Country": 5,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 25,
            "Country": 7,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 43,
            "Country": 3,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 40,
            "Country": 1,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 20,
            "Country": 7,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 41,
            "Country": 4,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 35,
            "Country": 4,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 59,
            "Country": 7,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 53,
            "Country": 1,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 67,
            "Country": 5,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 45,
            "Country": 3,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 72,
            "Country": 7,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 57,
            "Country": 4,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 26,
            "Country": 1,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 56,
            "Country": 4,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 22,
            "Country": 4,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 65,
            "Country": 7,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 32,
            "Country": 2,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 24,
            "Country": 4,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 59,
            "Country": 2,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 68,
            "Country": 6,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 71,
            "Country": 1,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 60,
            "Country": 6,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 69,
            "Country": 5,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 60,
            "Country": 2,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 79,
            "Country": 6,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 77,
            "Country": 6,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 35,
            "Country": 5,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 49,
            "Country": 6,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 31,
            "Country": 2,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 65,
            "Country": 5,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 74,
            "Country": 5,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 59,
            "Country": 2,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 60,
            "Country": 1,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 61,
            "Country": 2,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "ایالات متحده آمریکا",
            "Age": 25,
            "Country": 2,
            "Address": "جان دئو",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 27,
            "Country": 6,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 74,
            "Country": 4,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 35,
            "Country": 1,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 31,
            "Country": 2,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 43,
            "Country": 4,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 55,
            "Country": 6,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 43,
            "Country": 6,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 79,
            "Country": 5,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 37,
            "Country": 5,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 44,
            "Country": 3,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 68,
            "Country": 1,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 69,
            "Country": 5,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 80,
            "Country": 4,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 23,
            "Country": 7,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 76,
            "Country": 1,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 40,
            "Country": 1,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 44,
            "Country": 5,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 77,
            "Country": 6,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 38,
            "Country": 7,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 30,
            "Country": 1,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 56,
            "Country": 4,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 62,
            "Country": 3,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 36,
            "Country": 1,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 58,
            "Country": 4,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 55,
            "Country": 7,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 39,
            "Country": 2,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 29,
            "Country": 2,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 80,
            "Country": 4,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 60,
            "Country": 4,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 80,
            "Country": 1,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 46,
            "Country": 7,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 31,
            "Country": 6,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 43,
            "Country": 4,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        },
        {
            "Name": "جان دئو",
            "Age": 25,
            "Country": 7,
            "Address": "ایالات متحده آمریکا",
            "Married": true
        },
        {
            "Name": "جان دئو",
            "Age": 59,
            "Country": 6,
            "Address": "ایالات متحده آمریکا",
            "Married": false
        }
    ];
    db.users = [
        {
            "ID": "x",
            "Account": "A758A693-0302-03D1-AE53-EEFE22855556",
            "Name": "Carson Kelley",
            "RegisterDate": "1382-04-20T22:55:52-07:00"
        },
        {
            "Account": "D89FF524-1233-0CE7-C9E1-56EFF017A321",
            "Name": "Prescott Griffin",
            "RegisterDate": "1391-02-22T05:59:55-08:00"
        },
        {
            "Account": "06FAAD9A-5114-08F6-D60C-961B2528B4F0",
            "Name": "Amir Saunders",
            "RegisterDate": "1394-08-13T09:17:49-07:00"
        },
        {
            "Account": "EED7653D-7DD9-A722-64A8-36A55ECDBE77",
            "Name": "Derek Thornton",
            "RegisterDate": "1392-02-27T01:31:07-08:00"
        },
        {
            "Account": "2A2E6D40-FEBD-C643-A751-9AB4CAF1E2F6",
            "Name": "Fletcher Romero",
            "RegisterDate": "1390-06-25T15:49:54-07:00"
        },
        {
            "Account": "3978F8FA-DFF0-DA0E-0A5D-EB9D281A3286",
            "Name": "Thaddeus Stein",
            "RegisterDate": "1393-11-10T07:29:41-08:00"
        },
        {
            "Account": "658DBF5A-176E-569A-9273-74FB5F69FA42",
            "Name": "Nash Knapp",
            "RegisterDate": "1385-06-24T09:11:19-07:00"
        },
        {
            "Account": "76D2EE4B-7A73-1212-F6F2-957EF8C1F907",
            "Name": "Quamar Vega",
            "RegisterDate": "1391-04-13T20:06:29-07:00"
        },
        {
            "Account": "00E46809-A595-CE82-C5B4-D1CAEB7E3E58",
            "Name": "Philip Galloway",
            "RegisterDate": "1388-08-21T18:59:38-07:00"
        },
        {
            "Account": "C196781C-DDCC-AF83-DDC2-CA3E851A47A0",
            "Name": "Mason French",
            "RegisterDate": "1380-11-15T00:38:37-08:00"
        },
        {
            "Account": "5911F201-818A-B393-5888-13157CE0D63F",
            "Name": "Ross Cortez",
            "RegisterDate": "1390-05-27T17:35:32-07:00"
        },
        {
            "Account": "B8BB78F9-E1A1-A956-086F-E12B6FE168B6",
            "Name": "Logan King",
            "RegisterDate": "1383-07-08T16:58:06-07:00"
        },
        {
            "Account": "06F636C3-9599-1A2D-5FD5-86B24ADDE626",
            "Name": "Cedric Leblanc",
            "RegisterDate": "1391-06-30T14:30:10-07:00"
        },
        {
            "Account": "FE880CDD-F6E7-75CB-743C-64C6DE192412",
            "Name": "Simon Sullivan",
            "RegisterDate": "1393-06-11T16:35:07-07:00"
        },
        {
            "Account": "BBEDD673-E2C1-4872-A5D3-C4EBD4BE0A12",
            "Name": "Jamal West",
            "RegisterDate": "1381-03-16T20:18:29-08:00"
        },
        {
            "Account": "19BC22FA-C52E-0CC6-9552-10365C755FAC",
            "Name": "Hector Morales",
            "RegisterDate": "1392-11-01T01:56:34-07:00"
        },
        {
            "Account": "A8292214-2C13-5989-3419-6B83DD637D6C",
            "Name": "Herrod Hart",
            "RegisterDate": "1388-03-13T19:21:04-07:00"
        },
        {
            "Account": "0285564B-F447-0E7F-EAA1-7FB8F9C453C8",
            "Name": "Clark Maxwell",
            "RegisterDate": "1384-08-05T08:22:24-07:00"
        },
        {
            "Account": "EA78F076-4F6E-4228-268C-1F51272498AE",
            "Name": "Reuben Walter",
            "RegisterDate": "1391-01-23T01:55:59-08:00"
        },
        {
            "Account": "6A88C194-EA21-426F-4FE2-F2AE33F51793",
            "Name": "Ira Ingram",
            "RegisterDate": "1388-08-15T05:57:46-07:00"
        },
        {
            "Account": "4275E873-439C-AD26-56B3-8715E336508E",
            "Name": "Damian Morrow",
            "RegisterDate": "1395-09-13T01:50:55-07:00"
        },
        {
            "Account": "A0D733C4-9070-B8D6-4387-D44F0BA515BE",
            "Name": "Macon Farrell",
            "RegisterDate": "1391-03-14T05:41:40-07:00"
        },
        {
            "Account": "B3683DE8-C2FA-7CA0-A8A6-8FA7E954F90A",
            "Name": "Joel Galloway",
            "RegisterDate": "1383-02-03T04:19:01-08:00"
        },
        {
            "Account": "01D95A8E-91BC-2050-F5D0-4437AAFFD11F",
            "Name": "Rigel Horton",
            "RegisterDate": "1395-06-20T11:53:11-07:00"
        },
        {
            "Account": "F0D12CC0-31AC-A82E-FD73-EEEFDBD21A36",
            "Name": "Sylvester Gaines",
            "RegisterDate": "1384-03-12T09:57:13-08:00"
        },
        {
            "Account": "874FCC49-9A61-71BC-2F4E-2CE88348AD7B",
            "Name": "Abbot Mckay",
            "RegisterDate": "1388-12-26T20:42:57-08:00"
        },
        {
            "Account": "B8DA1912-20A0-FB6E-0031-5F88FD63EF90",
            "Name": "Solomon Green",
            "RegisterDate": "1393-09-04T01:44:47-07:00"
        }
     ];
}());